precision highp float;
varying vec2 v_Uv;
uniform sampler2D u_Input;
uniform sampler2D u_Input2;
uniform sampler2D u_Input3;
uniform sampler2D u_albedo1;
uniform sampler2D u_mask;
uniform sampler2D u_KiraTexture;
uniform float kira1_scale;
uniform float kira2_scale;
uniform float kira3_scale;
uniform float kira1_bright;
uniform float kira2_bright;
uniform float kira3_bright;
uniform float kira1_alpha;
uniform float kira2_alpha;
uniform float kira3_alpha;
uniform vec4 speed;
varying float weight_kira;
uniform float Rotation;
uniform float intensity;

uniform float time;
uniform float randValue;

varying highp vec2 textureCoordinate;

varying vec4 v_Color;
uniform float strength;

#define PI 3.1415926

// snow color
vec3 RGBToHSL(vec3 color){
    vec3 hsl;
    float fmin=min(min(color.r,color.g),color.b);
    float fmax=max(max(color.r,color.g),color.b);
    float delta=fmax-fmin;
    
    hsl.z=(fmax+fmin)/2.;
    
    if(delta==0.)
    {
        hsl.x=0.;
        hsl.y=0.;
    }
    else
    {
        if(hsl.z<.5)
        hsl.y=delta/(fmax+fmin);
        else
        hsl.y=delta/(2.-fmax-fmin);
        
        float deltaR=(((fmax-color.r)/6.)+(delta/2.))/delta;
        float deltaG=(((fmax-color.g)/6.)+(delta/2.))/delta;
        float deltaB=(((fmax-color.b)/6.)+(delta/2.))/delta;
        
        if(color.r==fmax)
        hsl.x=deltaB-deltaG;
        else if(color.g==fmax)
        hsl.x=(1./3.)+deltaR-deltaB;
        else if(color.b==fmax)
        hsl.x=(2./3.)+deltaG-deltaR;
        
        if(hsl.x<0.)
        hsl.x+=1.;
        else if(hsl.x>1.)
        hsl.x-=1.;
    }
    
    return hsl;
}

float HueToRGB(float f1,float f2,float hue){
    if(hue<0.)
    hue+=1.;
    else if(hue>1.)
    hue-=1.;
    float res;
    if((6.*hue)<1.)
    res=f1+(f2-f1)*6.*hue;
    else if((2.*hue)<1.)
    res=f2;
    else if((3.*hue)<2.)
    res=f1+(f2-f1)*((2./3.)-hue)*6.;
    else
    res=f1;
    return res;
}

vec3 HSLToRGB(vec3 hsl){
    vec3 rgb;
    
    if(hsl.y==0.)
    rgb=vec3(hsl.z);
    else
    {
        float f2;
        
        if(hsl.z<.5)
        f2=hsl.z*(1.+hsl.y);
        else
        f2=(hsl.z+hsl.y)-(hsl.y*hsl.z);
        
        float f1=1.4*hsl.z-f2;
        
        rgb.r=HueToRGB(f1,f2,hsl.x+(1./3.));
        rgb.g=HueToRGB(f1,f2,hsl.x);
        rgb.b=HueToRGB(f1,f2,hsl.x-(1./3.));
    }
    
    return rgb;
}

// snow hue
vec3 blendSnowHue(vec3 blend,vec3 bgColor){
    vec3 baseHSL=RGBToHSL(bgColor.rgb);
    return HSLToRGB(vec3(RGBToHSL(blend.rgb).r,baseHSL.g,baseHSL.b));
}

vec2 rot(float angle, vec2 uv)
{
    float theta = angle * PI / 180.;
    mat2 r = mat2(cos(theta), -sin(theta), sin(theta), cos(theta));
    return uv * r;
}

float random (vec2 st) {
    return fract(sin(dot(st.xy, vec2(12.9898,78.233)))* 43758.5453123);
}

vec2 center2scale(vec2 inputUv, float inputScale){
    vec2 tmpUv = inputUv - 0.5;
    tmpUv = tmpUv * (1./inputScale);
    tmpUv = tmpUv + 0.5;
    return tmpUv;
}
vec3 blendNormal(vec3 base, vec3 blend) {
    return blend;
}

vec3 blendNormal(vec3 base, vec3 blend, float opacity) {
    return (blendNormal(base, blend) * opacity + blend * (1.0 - opacity));
}

float blendColorDodge(float base, float blend) {
    return (blend==1.0)?blend:min(base/(1.0-blend),1.0);
}

vec3 blendColorDodge(vec3 base, vec3 blend) {
    return vec3(blendColorDodge(base.r,blend.r),blendColorDodge(base.g,blend.g),blendColorDodge(base.b,blend.b));
}


mat4 saturationMatrix(float saturation ) {
    vec3 luminance = vec3( 0.3086, 0.6094, 0.0820 );
    float oneMinusSat = 1.0 - saturation;
    vec3 red = vec3( luminance.x * oneMinusSat );
    red.r += saturation;
    
    vec3 green = vec3( luminance.y * oneMinusSat );
    green.g += saturation;
    
    vec3 blue = vec3( luminance.z * oneMinusSat );
    blue.b += saturation;
    
    return mat4( 
        red,     0,
        green,   0,
        blue,    0,
        0, 0, 0, 1 );
}

//饱和度调节
vec4 saturationAdjust(vec4 col,float saturation){
    vec4 fragColor = saturationMatrix(saturation) * col;
    return fragColor;
}

void main()
{
    
    vec2 uv = textureCoordinate;
    uv = (textureCoordinate + 1.0)*0.50;
    uv = vec2(1.0,1.0)*(rot(Rotation,(uv-.5))+0.5);
    vec4 color2 = texture2D(u_Input2, center2scale(uv, 1.0));
    // color2.rgb = blendSnowHue(v_Color.rgb, color2.rgb); 
    gl_FragColor = vec4(color2.rgb * kira2_bright, color2.a);

    // gl_FragColor = saturationAdjust(gl_FragColor,strength);
        // gl_FragColor.r = 1.0;
    gl_FragColor.a = kira2_alpha*strength;
    // gl_FragColor = vec4(0.0,1.0,0.0,1.0);
    
}
