#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float intensity;
    float opacity;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 texCoord [[user(texCoord)]];
    float2 sucaiTexCoord [[user(sucaiTexCoord)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> u_FBOTexture [[texture(0)]], texture2d<float> sucaiImageTexture [[texture(1)]], sampler u_FBOTextureSmplr [[sampler(0)]], sampler sucaiImageTextureSmplr [[sampler(1)]])
{
    main0_out out = {};
    float4 _37 = sucaiImageTexture.sample(sucaiImageTextureSmplr, in.sucaiTexCoord);
    float _46 = _37.w;
    float3 _55 = u_FBOTexture.sample(u_FBOTextureSmplr, in.texCoord).xyz;
    out.gl_FragColor = float4(mix(_55, mix(_55, _55 * fast::clamp(_37.xyz * (1.0 / _46), float3(0.0), float3(1.0)), float3(_46)), float3(buffer.intensity * buffer.opacity)), 1.0);
    return out;
}

