local exports = exports or {}
local BuiltinFXAA = BuiltinFXAA or {}
BuiltinFXAA.__index = BuiltinFXAA

local kFxaaVS = [[
attribute vec3 inPosition;
attribute vec2 inTexCoord;
varying vec2 v_uv;
void main() {
    gl_Position = vec4(inPosition, 1.0);
    v_uv = inTexCoord;
}
]]

local kFxaaVS_metal = 
[==[
#include <metal_stdlib>
#include <simd/simd.h>
using namespace metal;
struct main0_out {
    float2 v_uv [[user(locn0)]];
    float4 gl_Position [[position]];
};
struct main0_in {
    float3 inPosition [[attribute(0)]];
    float2 inTexCoord [[attribute(1)]];
};
vertex main0_out main0(main0_in in [[stage_in]]) {
    main0_out out = {};
    out.gl_Position = float4(in.inPosition, 1.0);
    out.v_uv = in.inTexCoord;
    out.gl_Position.z = (out.gl_Position.z + out.gl_Position.w) * 0.5;       // Adjust clip-space for Metal
    return out;
}
]==]


local kFxaaFS1 = [[
    precision highp float;    
    varying vec2 v_uv;
    uniform sampler2D _MainTex;
    uniform vec4  u_ScreenParams;
    
    #define EDGE_STEP_COUNT 10
    #define EDGE_STEPS 1.0, 1.5, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 4.0
    #define EDGE_GUESS 8.0
    
    
    const float _ContrastThreshold = 0.0312;
    const float _RelativeThreshold = 0.063;
    const float _SubpixelBlending = 1.0;
    
    struct LuminanceData {
        float m, n, e, s, w;
        float highest, lowest, contrast;
        float ne, nw, se, sw;
    };
    
    struct EdgeData
    {
        bool isHorizontal;
        float pixelStep;
        float oppositeLuminance, gradient;
    };
    
    vec4 Sample(vec2 uv)
    {
        return texture2D(_MainTex, uv);
    }
    
    float SampleLuminance(vec2 uv)
    {
        //default luminance green
        return Sample(uv).g;
    }
    
    float SampleLuminance(vec2 uv, float uOffset, float vOffset)
    {
        vec2 texture_texelSize = u_ScreenParams.zw - vec2(1.0);
        uv += texture_texelSize * vec2(uOffset, vOffset);
        return SampleLuminance(uv);
    }
    
    LuminanceData SampleLuminanceNeighborhood(vec2 uv)
    {
        LuminanceData l;
        l.m = SampleLuminance(uv);
        l.n = SampleLuminance(uv, 0.0, 1.0);
        l.e = SampleLuminance(uv, 1.0, 0.0);
        l.s = SampleLuminance(uv, 0.0, -1.0);
        l.w = SampleLuminance(uv, -1.0, 0.0);
    
        l.ne = SampleLuminance(uv, 1.0, 1.0);
        l.nw = SampleLuminance(uv, -1.0, 1.0);
        l.se = SampleLuminance(uv, 1.0, -1.0);
        l.sw = SampleLuminance(uv, -1.0, -1.0);
    
        l.highest = max(max(max(max(l.n, l.e), l.s), l.w), l.m);
        l.lowest = min(min(min(min(l.n, l.e), l.s), l.w), l.m);
    
        l.contrast = l.highest - l.lowest;
        return l;
    }
    
    float DeterminPixelBlendFactor(LuminanceData l)
    {
        float f = 2.0 * (l.n + l.e + l.s + l.w);
        f += l.ne + l.nw + l.se + l.sw;
        f *= 1.0/12.0;
        f = abs(f - l.m);
        f = clamp(f/l.contrast, 0.0, 1.0);
        float blendFactor = smoothstep(0.0, 1.0, f);
        return blendFactor * blendFactor * _SubpixelBlending;
    }
    
    EdgeData DeterminEdge(LuminanceData l)
    {
        EdgeData e;
        vec2 texture_texelSize = u_ScreenParams.zw - vec2(1.0);
        float horizontal = 
            abs(l.n + l.s - 2.0 * l.m) * 2.0 + 
            abs(l.ne + l.se - 2.0 * l.e) +
            abs(l.nw + l.sw - 2.0 * l.w);
        float vertical = 
            abs(l.e + l.w - 2.0 * l.m) * 2.0 + 
            abs(l.ne + l.nw - 2.0 * l.n) + 
            abs(l.se + l.sw - 2.0 * l.s);
        if(horizontal >= vertical)
        {
            e.isHorizontal = true;
        }else{
            e.isHorizontal = false;
        }
        
        float pLuminance = e.isHorizontal ? l.n : l.e;
        float nLuminance = e.isHorizontal ? l.s : l.w;
        float pGradient = abs(pLuminance - l.m);
        float nGradient = abs(nLuminance - l.m);
    
        e.pixelStep = e.isHorizontal ? texture_texelSize.y : texture_texelSize.x;
        if(pGradient < nGradient)
        {
            e.pixelStep = -e.pixelStep;
            e.oppositeLuminance = nLuminance;
            e.gradient = nGradient;
        }else
        {
            e.oppositeLuminance = pLuminance;
            e.gradient = pGradient;
        }
    
        return e;
    }
    
    float DeterminEdgeBlendFactor(LuminanceData l, EdgeData e, vec2 uv)
    {
        float edgeSteps[10];
        edgeSteps[0] = 1.0;
        edgeSteps[1] = 1.5;
        edgeSteps[2] = 2.0;
        edgeSteps[3] = 2.0;
        edgeSteps[4] = 2.0;
        edgeSteps[5] = 2.0;
        edgeSteps[6] = 2.0;
        edgeSteps[7] = 2.0;
        edgeSteps[8] = 2.0;
        edgeSteps[9] = 4.0;
    
        vec2 uvEdge = uv;
        vec2 edgeStep;
        vec2 texture_texelSize = u_ScreenParams.zw - vec2(1.0);
        if(e.isHorizontal)
        {
            uvEdge.y += e.pixelStep * 0.5;
            edgeStep = vec2(texture_texelSize.x , 0.0);
        }else{
            uvEdge.x += e.pixelStep * 0.5;
            edgeStep = vec2(0.0, texture_texelSize.y);
        }
    
        float edgeLuminance = (l.m + e.oppositeLuminance) * 0.5;
        float gradientThreshold = e.gradient * 0.25;
    
        vec2 puv = uvEdge + edgeStep * edgeSteps[0];
        float pLuminanceDelta = SampleLuminance(puv) - edgeLuminance;
        bool pAtEnd = abs(pLuminanceDelta) >= gradientThreshold;
    
        for(int i = 1; i < EDGE_STEP_COUNT && !pAtEnd; i++)
        {
            puv += edgeStep * edgeSteps[i];
            pLuminanceDelta = SampleLuminance(puv) - edgeLuminance;
            pAtEnd = abs(pLuminanceDelta) >= gradientThreshold;
        }
    
        if(!pAtEnd)
        {
            puv += edgeStep * EDGE_GUESS;
        }
    
        vec2 nuv = uvEdge - edgeStep * edgeSteps[0];
        float nLuminanceDelta = SampleLuminance(nuv) - edgeLuminance;
        bool nAtEnd = abs(nLuminanceDelta) >= gradientThreshold;
    
        for(int i = 0; i < EDGE_STEP_COUNT && !nAtEnd; i++)
        {
            nuv -= edgeStep * edgeSteps[i];
            nLuminanceDelta = SampleLuminance(nuv) - edgeLuminance;
            nAtEnd = abs(nLuminanceDelta) >= gradientThreshold;
        }
    
        if(!nAtEnd){
            nuv -= edgeStep * EDGE_GUESS;
        }
    
    
    
        float pDistance, nDistance;
        if(e.isHorizontal)
        {
            pDistance = puv.x - uv.x;
            nDistance = uv.x - nuv.x;
        }else{
            pDistance = puv.y - uv.y;
            nDistance = uv.y - nuv.y;
        }
    
        float shortestDistance;
        bool deltaSign;
        if(pDistance <= nDistance)
        {
            shortestDistance = pDistance;
            deltaSign = pLuminanceDelta >= 0.0;
        }
        else
        {
            shortestDistance = nDistance;
            deltaSign = nLuminanceDelta >= 0.0;
        }
    
    
        if(deltaSign == (l.m - edgeLuminance >= 0.0)){
            return 0.0;
        }
    
        
        return 0.5 - shortestDistance /(pDistance + nDistance);
        return 0.0;
    }
    
    bool ShouldSkipPixel(LuminanceData l)
    {
        float threshold = 
            max(_ContrastThreshold, _RelativeThreshold * l.highest);
        return l.contrast < threshold;
    }
    
    vec4 ApplyFXAA(vec2 uv)
    {
        if (u_ScreenParams.z < 1.0 || u_ScreenParams.w < 1.0)
        {
            return Sample(uv);
        }

        LuminanceData l = SampleLuminanceNeighborhood(uv);
    
        if(ShouldSkipPixel(l))
        {
            return Sample(uv);
        }
    
        float pixelBlend = DeterminPixelBlendFactor(l);
        EdgeData e = DeterminEdge(l);
        
        float edgeBlend = DeterminEdgeBlendFactor(l, e, uv);
        float finalBlend = max(pixelBlend, edgeBlend);
    
        if(e.isHorizontal)
        {
            uv.y += e.pixelStep * finalBlend;
        }
        else
        {
            uv.x += e.pixelStep * finalBlend;
        }
    
        return Sample(uv);
    }
    
    void main()
    {
        vec4 color = ApplyFXAA(v_uv);
        gl_FragColor = color;
    }
    ]]

    local kFxaaFS1_metal = 
    [==[
    #pragma clang diagnostic ignored "-Wmissing-prototypes"
    #pragma clang diagnostic ignored "-Wmissing-braces"
    #include <metal_stdlib>
    #include <simd/simd.h>
    using namespace metal;
    template<typename T, size_t Num>
    struct spvUnsafeArray {
    T elements[Num ? Num : 1];
    
    thread T& operator [] (size_t pos) thread {
        return elements[pos];
    }
    constexpr const thread T& operator [] (size_t pos) const thread {
        return elements[pos];
    }
    
    device T& operator [] (size_t pos) device
    {
        return elements[pos];
    }
    constexpr const device T& operator [] (size_t pos) const device
    {
        return elements[pos];
    }
    
    constexpr const constant T& operator [] (size_t pos) const constant
    {
        return elements[pos];
    }
    
    threadgroup T& operator [] (size_t pos) threadgroup {
        return elements[pos];
    }
    constexpr const threadgroup T& operator [] (size_t pos) const threadgroup
    {
        return elements[pos];
    }
    };
    struct buffer_t {
        float4 u_ScreenParams;
    };
    struct main0_out
    {
        float4 gl_FragColor [[color(0)]];
    };
    struct main0_in
    {
        float2 v_uv [[user(locn0)]];
    };
fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> _MainTex [[texture(0)]], sampler _MainTexSmplr [[sampler(0)]]) {
    main0_out out = {};
    float4 _1844;
    do
    {
        bool _770 = buffer.u_ScreenParams.z < 1.0;
        bool _777;
        if (!_770) {
            _777 = buffer.u_ScreenParams.w < 1.0;
        }
        else {
            _777 = _770;
        }
        if (_777)
        {
            _1844 = _MainTex.sample(_MainTexSmplr, in.v_uv);
            break;
        }
        float4 _936 = _MainTex.sample(_MainTexSmplr, in.v_uv);
        float _930 = _936.y;
        float2 _944 = buffer.u_ScreenParams.zw - float2(1.0);
        float4 _965 = _MainTex.sample(_MainTexSmplr, fma(_944, float2(0.0, 1.0), in.v_uv));
        float _959 = _965.y;
        float4 _994 = _MainTex.sample(_MainTexSmplr, fma(_944, float2(1.0, 0.0), in.v_uv));
        float _988 = _994.y;
        float4 _1023 = _MainTex.sample(_MainTexSmplr, fma(_944, float2(0.0, -1.0), in.v_uv));
        float _1017 = _1023.y;
        float4 _1052 = _MainTex.sample(_MainTexSmplr, fma(_944, float2(-1.0, 0.0), in.v_uv));
        float _1046 = _1052.y;
        float4 _1081 = _MainTex.sample(_MainTexSmplr, (in.v_uv + _944));
        float _1075 = _1081.y;
        float4 _1110 = _MainTex.sample(_MainTexSmplr, fma(_944, float2(-1.0, 1.0), in.v_uv));
        float _1104 = _1110.y;
        float4 _1139 = _MainTex.sample(_MainTexSmplr, fma(_944, float2(1.0, -1.0), in.v_uv));
        float _1133 = _1139.y;
        float4 _1168 = _MainTex.sample(_MainTexSmplr, fma(_944, float2(-1.0), in.v_uv));
        float _1162 = _1168.y;
        float _901 = fast::max(fast::max(fast::max(fast::max(_959, _988), _1017), _1046), _930);
        float _922 = _901 - fast::min(fast::min(fast::min(fast::min(_959, _988), _1017), _1046), _930);
        if (_922 < fast::max(0.031199999153614044189453125, 0.063000001013278961181640625 * _901)) {
            _1844 = _936;
            break;
        }
        float _1208 = _1075 + _1104;
        float _1230 = smoothstep(0.0, 1.0, fast::clamp(abs(fma(fma(2.0, ((_959 + _988) + _1017) + _1046, (_1208 + _1133) + _1162), 0.083333335816860198974609375, -_930)) / _922, 0.0, 1.0));
        bool _1865 = ((fma(abs(fma(-2.0, _930, _959 + _1017)), 2.0, abs(fma(-2.0, _988, _1075 + _1133))) + abs(fma(-2.0, _1046, _1104 + _1162))) >= (fma(abs(fma(-2.0, _930, _988 + _1046)), 2.0, abs(fma(-2.0, _959, _1208))) + abs(fma(-2.0, _1017, _1133 + _1162)))) ? true : false;
        float _1866 = _1865 ? _959 : _988;
        float _1867 = _1865 ? _1017 : _1046;
        float _1349 = abs(_1866 - _930);
        float _1354 = abs(_1867 - _930);
        float _1792;
        if (_1865)
        {
            _1792 = _944.y;
        }
        else
        {
            _1792 = _944.x;
        }
        bool _1368 = _1349 < _1354;
        float _1795;
        if (_1368)
        {
            _1795 = -_1792;
        }
        else
        {
            _1795 = _1792;
        }
        float _1834;
        do
        {
            spvUnsafeArray<float, 10> _1387;
            _1387[0] = 1.0;
            _1387[1] = 1.5;
            _1387[2] = 2.0;
            _1387[3] = 2.0;
            _1387[4] = 2.0;
            _1387[5] = 2.0;
            _1387[6] = 2.0;
            _1387[7] = 2.0;
            _1387[8] = 2.0;
            _1387[9] = 4.0;
            float2 _1803;
            float2 _1804;
            if (_1865) {
                float2 _1766 = in.v_uv;
                _1766.y = fma(_1795, 0.5, in.v_uv.y);
                _1804 = float2(_944.x, 0.0);
                _1803 = _1766;
            }
            else {
                float2 _1770 = in.v_uv;
                _1770.x = fma(_1795, 0.5, in.v_uv.x);
                _1804 = float2(0.0, _944.y);
                _1803 = _1770;
            }
            float _1459 = (_1368 ? _1354 : _1349) * 0.25;
            float2 _1465 = _1803 + (_1804 * _1387[0]);
            float _1859 = -(_930 + (_1368 ? _1867 : _1866));
            float _1469 = fma(_1859, 0.5, _MainTex.sample(_MainTexSmplr, _1465).y);
            int _1805;
            bool _1806;
            float2 _1808;
            float _1829;
            _1829 = _1469;
            _1808 = _1465;
            _1806 = abs(_1469) >= _1459;
            _1805 = 1;
            bool _1479;
            for (;;)
            {
                _1479 = !_1806;
                if ((_1805 < 10) && _1479) {
                    float2 _1488 = _1808 + (_1804 * _1387[_1805]);
                    float _1492 = fma(_1859, 0.5, _MainTex.sample(_MainTexSmplr, _1488).y);
                    _1829 = _1492;
                    _1808 = _1488;
                    _1806 = abs(_1492) >= _1459;
                    _1805++;
                    continue;
                }
                else {
                    break;
                }
            }
            float2 _1818;
            if (_1479)
            {
                _1818 = _1808 + (_1804 * 8.0);
            }
            else
            {
                _1818 = _1808;
            }
            float2 _1514 = _1803 - (_1804 * _1387[0]);
            float _1518 = fma(_1859, 0.5, _MainTex.sample(_MainTexSmplr, _1514).y);
            int _1812;
            bool _1813;
            float2 _1815;
            float _1824;
            _1824 = _1518;
            _1815 = _1514;
            _1813 = abs(_1518) >= _1459;
            _1812 = 0;
            bool _1528;
            for (;;)
            {
                _1528 = !_1813;
                if ((_1812 < 10) && _1528)
                {
                    float2 _1537 = _1815 - (_1804 * _1387[_1812]);
                    float _1541 = fma(_1859, 0.5, _MainTex.sample(_MainTexSmplr, _1537).y);
                    _1824 = _1541;
                    _1815 = _1537;
                    _1813 = abs(_1541) >= _1459;
                    _1812++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            float2 _1819;
            if (_1528)
            {
                _1819 = _1815 - (_1804 * 8.0);
            }
            else
            {
                _1819 = _1815;
            }
            float _1820;
            float _1821;
            if (_1865)
            {
                _1821 = in.v_uv.x - _1819.x;
                _1820 = _1818.x - in.v_uv.x;
            }
            else
            {
                _1821 = in.v_uv.y - _1819.y;
                _1820 = _1818.y - in.v_uv.y;
            }
            bool _1585 = _1820 <= _1821;
            bool _1830;
            if (_1585)
            {
                _1830 = _1829 >= 0.0;
            }
            else
            {
                _1830 = _1824 >= 0.0;
            }
            if (_1830 == (fma(_1859, 0.5, _930) >= 0.0))
            {
                _1834 = 0.0;
                break;
            }
            _1834 = 0.5 - ((_1585 ? _1820 : _1821) / (_1820 + _1821));
            break;
        } while(false);
        float _800 = fast::max(_1230 * _1230, _1834);
        float2 _1843;
        if (_1865) {
            float2 _1782 = in.v_uv;
            _1782.y = fma(_1795, _800, in.v_uv.y);
            _1843 = _1782;
        }
        else
        {
            float2 _1785 = in.v_uv;
            _1785.x = fma(_1795, _800, in.v_uv.x);
            _1843 = _1785;
        }
        _1844 = _MainTex.sample(_MainTexSmplr, _1843);
        break;
    } while(false);
    out.gl_FragColor = _1844;
    return out;
}
    ]==]
    local function CreateRenderTexture(name, width, height, colorFormat)
        local rt = Amaz.RenderTexture()
        rt.name = name
        rt.builtinType = Amaz.BuiltInTextureType.NORMAL
        rt.internalFormat = Amaz.InternalFormat.RGBA8
        rt.dataType = Amaz.DataType.U8norm
        rt.depth = 1
        rt.filterMag = Amaz.FilterMode.LINEAR
        rt.filterMin = Amaz.FilterMode.LINEAR
        rt.filterMipmap = Amaz.FilterMipmapMode.NONE
        rt.width = width
        rt.height = height
        rt.colorFormat = colorFormat or Amaz.PixelFormat.RGBA8Unorm
        return rt
    end
    
    -- Material related
    local function CreateEmptyMaterial(materialName)
        local emptyMaterial = Amaz.Material()
        emptyMaterial.name = materialName
    
        local emptyXShader = Amaz.XShader()
        emptyXShader.name = materialName
    
        emptyMaterial.xshader = emptyXShader
    
        local emptyProperties = Amaz.PropertySheet()
        emptyMaterial.properties = emptyProperties
    
        return emptyMaterial
    end
    
    local function AddPassToMaterial(material, vertCode, fragCode, vertCode_metal, fragCode_metal, stencilMasked)
        local newPass = Amaz.Pass()
    
        local vs = Amaz.Shader()
        vs.type = Amaz.ShaderType.VERTEX
        vs.source = vertCode
    
        local fs = Amaz.Shader()
        fs.type = Amaz.ShaderType.FRAGMENT
        fs.source = fragCode
    
        local shaderVec = Amaz.Vector()
        shaderVec:pushBack(vs)
        shaderVec:pushBack(fs)
    
        local vs_metal = Amaz.Shader()
        vs_metal.type = Amaz.ShaderType.VERTEX
        vs_metal.source = vertCode_metal
    
        local fs_metal = Amaz.Shader()
        fs_metal.type = Amaz.ShaderType.FRAGMENT
        fs_metal.source = fragCode_metal
    
        local shaderVec_metal = Amaz.Vector()
        shaderVec_metal:pushBack(vs_metal)
        shaderVec_metal:pushBack(fs_metal)
    
        local shaderMap = Amaz.Map()
        shaderMap:insert("gles2", shaderVec)
        shaderMap:insert("metal", shaderVec_metal)
    
        newPass.shaders = shaderMap
    
        local semantics = Amaz.Map()
        semantics:insert("inPosition", Amaz.VertexAttribType.POSITION)   -- all post effect shaders must follow this tradition
        semantics:insert("inTexCoord", Amaz.VertexAttribType.TEXCOORD0)  -- all post effect shaders must follow this tradition
        newPass.semantics = semantics
        
        local depthStencilState = Amaz.DepthStencilState()
        depthStencilState.depthTestEnable = false
        
        local renderState = Amaz.RenderState()
        renderState.depthstencil = depthStencilState
    
        if stencilMasked ~= nil then
            depthStencilState.stencilTestEnable = true;
    
            local stencilOp = Amaz.StencilOpState();
            stencilOp.compareOp = Amaz.CompareOp.EQUAL;
            stencilOp.reference = 42;
            stencilOp.writeMask = 0;
    
            depthStencilState.stencilFront = stencilOp;
            depthStencilState.stencilBack = stencilOp;
        end
    
        newPass.renderState = renderState
    
        material.xshader.passes:pushBack(newPass)
    
        return newPass
    end


function BuiltinFXAA.new(construct, ...)
    local self = setmetatable({}, BuiltinFXAA)

    if self.material == nil then 
        local material = CreateEmptyMaterial("BulitinFxaa")
        AddPassToMaterial(material, kFxaaVS, kFxaaFS1, kFxaaVS_metal, kFxaaFS1_metal)
        self.material = material
    end
    self.commands_Fxaa = Amaz.CommandBuffer()
    if construct and BuiltinFXAA.constructor then BuiltinFXAA.constructor(self, ...) end
    return self
    
end



function BuiltinFXAA:constructor()
end

function BuiltinFXAA:onStart(comp,sys)
    local camera = comp.entity:getComponent("Camera")
    if camera then
        if (camera.type == Amaz.CameraType.ORTHO) then
            Amaz.LOGE("AE_LUA_TAG", "Camera type is ortho, skip fxaa")
            return
        end
        Amaz.LOGE("AE_LUA_TAG", "Camera type is perspective, run fxaa")
        sys:addScriptListener(camera, Amaz.CameraEvent.RENDER_IMAGE_EFFECTS, "renderImageEffects", sys)

        local colorFormat = Amaz.PixelFormat.RGBA8Unorm;
        if (camera.renderTexture.realColorFormat == Amaz.PixelFormat.RGBA16Sfloat or camera.renderTexture.realColorFormat == Amaz.PixelFormat.RGBA32Sfloat) then
            colorFormat = camera.renderTexture.colorFormat;
        end
        self.srcCopy = CreateRenderTexture("srcCopy", camera.renderTexture.width, camera.renderTexture.height, colorFormat);
        self.commands_Fxaa:blitWithMaterial(camera.renderTexture, self.srcCopy, self.material, 0);
        self.commands_Fxaa:blit(self.srcCopy,camera.renderTexture);
    end
end

function BuiltinFXAA:onUpdate(comp, deltaTime)
end

function BuiltinFXAA:onDestroy(comp)
    self.commands_Fxaa:clearAll()
    self.commands_Fxaa = nil
    self.srcCopy = nil
    self.material = nil
end

function BuiltinFXAA:renderImageEffects(sys, camera, eventType)
    camera.entity.scene:commitCommandBuffer(self.commands_Fxaa)
end
exports.BuiltinFXAA = BuiltinFXAA
return exports
